||----------------------------------------------------------------------||
||                                                                      ||
||	Section 2.5: Programming with Booleans				||
||                                                                      ||
||	(c) Simon Thompson, 1995.					||
||                                                                      ||
||----------------------------------------------------------------------||

||----------------------------------------------------------------------|| 
||	Exclusive or							||
||----------------------------------------------------------------------|| 

exOr :: bool -> bool -> bool
exOr x y = (x \/ y) & ~ (x & y)

||----------------------------------------------------------------------|| 
||	Negation							||
||----------------------------------------------------------------------|| 

myNot :: bool -> bool

myNot True  = False
myNot False = True

||----------------------------------------------------------------------|| 
||      Exclusive or again.                                             ||
||----------------------------------------------------------------------|| 

exOr' :: bool -> bool -> bool

exOr' True  x = ~x
exOr' False x = x

||----------------------------------------------------------------------|| 
||	Zero sales in a week?						||
||----------------------------------------------------------------------|| 

isZeroWeek :: num -> bool

isZeroWeek n = (sales n = 0)

sales :: num -> num	|| declaration of the sales function

||----------------------------------------------------------------------|| 
||	Zero sales for a week during a given period?			||
||----------------------------------------------------------------------|| 

zeroInPeriod :: num -> bool

zeroInPeriod 0     = isZeroWeek 0
zeroInPeriod (n+1) = zeroInPeriod n \/ isZeroWeek (n+1)

