||----------------------------------------------------------------------||
||                                                                      ||
||	Section 2.8: Programming with numbers and strings		||
||                                                                      ||
||	(c) Simon Thompson, 1995.					||
||                                                                      ||
||----------------------------------------------------------------------||

string == [char]

sales :: num -> num

||----------------------------------------------------------------------|| 
||	Printing a table: the top-level function.			||
||----------------------------------------------------------------------|| 

printTable :: num -> string

printTable n
  = heading ++ printWeeks n ++ printTotal n ++ printAverage n

||----------------------------------------------------------------------|| 
||	The heading							||
||----------------------------------------------------------------------|| 

heading :: string

heading = "       Week      Sales\n"

||----------------------------------------------------------------------|| 
||	Print the entries for the week, assuming we have		||
||		printWeek :: num -> string				||
||----------------------------------------------------------------------|| 

printWeeks :: num -> string

printWeeks 0     = printWeek 0
printWeeks (n+1) = printWeeks n ++ printWeek (n+1)

||----------------------------------------------------------------------|| 
||	Working bottom up, use the functions				||
||		shownum	  :: num -> string				||
||		showfloat :: num -> num -> string			||
||	and the justification functions ljustify, cjustify, rjustify.	||
||----------------------------------------------------------------------|| 

||----------------------------------------------------------------------|| 
||	Printing one week's entry.					||
||----------------------------------------------------------------------|| 

printWeek :: num -> string

printWeek n 
  = rPrintNum n ++ rPrintNum (sales n) ++ "\n"

offset :: num
offset = 10

||----------------------------------------------------------------------|| 
||	Numbers in the appropriate format.				||
||----------------------------------------------------------------------|| 

rPrintNum :: num -> string

rPrintNum n = rjustify offset (shownum n)

||----------------------------------------------------------------------|| 
||	Print the average.						||
||----------------------------------------------------------------------|| 

printAverage :: num -> string

printAverage n 
  = "\n     Average " ++ rPrintFloat (averageSales n)

||----------------------------------------------------------------------|| 
||	Exercises for the reader					||
||	Complete these definitions!					||
||----------------------------------------------------------------------|| 

averageSales :: num -> num
printTotal   :: num -> string
rPrintFloat  :: num -> string


