||----------------------------------------------------------------------||
||                                                                      ||
||	Section 2.9: Data structures: Tuples				||
||                                                                      ||
||	(c) Simon Thompson, 1995.					||
||                                                                      ||
||----------------------------------------------------------------------||

string == [char]

||----------------------------------------------------------------------|| 
||	A type of people.						||
||----------------------------------------------------------------------|| 

person == (string,string,num)

||----------------------------------------------------------------------|| 
||	Example tuples							||
||----------------------------------------------------------------------|| 

joe :: person
joe = ("Joe Grundy","0000-000000",73)

mary :: person
mary =  ("Mary Poppins","0800-000-000",68)

nump :: (num,num)
nump =  (34,32)

||----------------------------------------------------------------------|| 
||	Specifying the type of a function minNmax.			||
||----------------------------------------------------------------------|| 

minNmax :: num -> num -> num -> (num,num)

||----------------------------------------------------------------------|| 
||	Pattern matching: adding a pair of numbers.			||
||----------------------------------------------------------------------|| 

addPair :: (num,num) -> num

addPair (x,y) = x+y

||----------------------------------------------------------------------|| 
||	Shifting numbers around.					||
||----------------------------------------------------------------------|| 

shift :: ((num,num),num) -> (num,(num,num))

shift ((a,b),c) = (a,(b,c))

||----------------------------------------------------------------------|| 
||	Selecting components of a tuple using functions.		||
||----------------------------------------------------------------------|| 

name  :: person -> string
phone :: person -> string
age   :: person -> num

name  (n,p,a) = n
phone (n,p,a) = p
age   (n,p,a) = a

||----------------------------------------------------------------------|| 
||	Built-in functions on pairs.					||
||		fst (x,y) = x						||
||		snd (x,y) = y						||
||----------------------------------------------------------------------|| 

||----------------------------------------------------------------------|| 
||	Adding two numbers.						||
||----------------------------------------------------------------------|| 

addTwo :: num -> num -> num

addTwo a b = a+b
