||----------------------------------------------------------------------||
||                                                                      ||
||	Chapter 3: Reasoning about programs				||
||                                                                      ||
||	(c) Simon Thompson, 1995.					||
||                                                                      ||
||----------------------------------------------------------------------||

||----------------------------------------------------------------------|| 
||	Swapping the elements of a pair.				||
||----------------------------------------------------------------------|| 

swap :: (num,num) -> (num,num)

swap (a,b) = (b,a)

||----------------------------------------------------------------------|| 
||	Cycling the elements of a 3-tuple.				||
||----------------------------------------------------------------------|| 

cycle , recycle :: (num,num,num) -> (num,num,num)

cycle (a,b,c)   = (b,c,a)
recycle (a,b,c) = (c,a,b)

||----------------------------------------------------------------------|| 
||	Maximum of two numbers.						||
||----------------------------------------------------------------------|| 

maxi :: num -> num -> num

maxi n m 
  = n      , if n>=m
  = m      , otherwise

||----------------------------------------------------------------------|| 
||	Conditional swap.						||
||----------------------------------------------------------------------|| 

swapIf :: (num,num) -> (num,num)

swapIf (a,b) 
  = (a,b)     , if a <= b
  = (b,a)     , otherwise

||----------------------------------------------------------------------|| 
||	Factorial.							||
||----------------------------------------------------------------------|| 

fac :: num -> num

fac 0     = 1
fac (n+1) = (n+1) * fac n

||----------------------------------------------------------------------|| 
||	Powers of two.							||
||----------------------------------------------------------------------|| 

power2 :: num -> num

power2 0     = 1
power2 (n+1) = 2 * power2 n

||----------------------------------------------------------------------|| 
||	Sums of powers of two.						||
||----------------------------------------------------------------------|| 

sumPowers :: num -> num

sumPowers 0     = 1
sumPowers (n+1) = sumPowers n + power2 (n+1)


