||----------------------------------------------------------------------||
||                                                                      ||
||	Section 4.3: Designing functions over lists			||
||                                                                      ||
||	(c) Simon Thompson, 1995.					||
||                                                                      ||
||----------------------------------------------------------------------||

string == [char]

||----------------------------------------------------------------------|| 
||	Sorting a list of numbers.					||
||----------------------------------------------------------------------|| 

iSort :: [num] -> [num]

iSort []    = [] 
iSort (a:x) = insert a (iSort x) 

||----------------------------------------------------------------------|| 
||	Inserting an element in the proper place.			||
||----------------------------------------------------------------------|| 

insert :: num -> [num] -> [num]

insert a []    = [a] 
insert a (b:y) = a:(b:y)            , if a <= b 
               = b : insert a y     , otherwise

||----------------------------------------------------------------------|| 
||	 Is a number a member of a list?				||
||----------------------------------------------------------------------|| 

memberList :: [num] -> num -> bool

memberList []    b = False
memberList (a:x) b = (a=b) \/ memberList x b

||----------------------------------------------------------------------|| 
||	alternative definition of member.				||
||----------------------------------------------------------------------|| 

mem :: [num] -> num -> bool

mem []    b = False
mem (a:x) b = True            , if (a=b)
            = mem x b         , otherwise

||----------------------------------------------------------------------|| 
||	Getting the digits in a string.					||
||----------------------------------------------------------------------|| 

digits :: string -> string

digits [] = []
digits (first:rest) 
  = first : digits rest    , if digit first
  =         digits rest    , otherwise

||----------------------------------------------------------------------|| 
||	Summing a list of pairs.					||
||									||
||	sumPairs :: [(num,num)] -> num					||
||									||
||----------------------------------------------------------------------|| 

sumPairs1 [] = 0
sumPairs1 (a:x) = fst a + snd a + sumPairs1 x 

sumPairs2 [] = 0
sumPairs2 (a:x) = c + d + sumPairs2 x 
                  where
                  c = fst a
                  d = snd a

sumPairs3 [] = 0
sumPairs3 (a:x) = c + d + sumPairs3 x 
                  where
                  (c,d) = a

sumPairs4 [] = 0
sumPairs4 ((c,d):x) = c + d + sumPairs4 x 

sumPairs5 [] = 0
sumPairs5 (a:x) = sumPair a + sumPairs5 x

||----------------------------------------------------------------------|| 
||	Summing a pair.							||
||----------------------------------------------------------------------|| 

sumPair :: (num,num) -> num

sumPair  (c,d) = c+d

||----------------------------------------------------------------------|| 
||	Zip2 is built in						||
||									||
||	zip2 (a:x) (b:y) = (a,b) : zip2 x y				||
||	zip2 x y         = []						||
||----------------------------------------------------------------------|| 


||----------------------------------------------------------------------|| 
||	Alternative definition of zip.					||
||----------------------------------------------------------------------|| 

zipNew :: [num] -> [num] -> [(num,num)]

zipNew (a:x) (b:y) = (a,b) : zipNew x y
zipNew (a:x) []    = []
zipNew []    y     = []

