||----------------------------------------------------------------------||
||                                                                      ||
||	Section 4.4: A library database					||
||                                                                      ||
||	(c) Simon Thompson, 1995.					||
||                                                                      ||
||----------------------------------------------------------------------||

||----------------------------------------------------------------------|| 
||	Types used in the system.					||
||----------------------------------------------------------------------|| 

string == [char]

person == string
book   == string
||----------------------------------------------------------------------|| 
||	The database type.						||
||----------------------------------------------------------------------|| 

database == [ (person , book) ] 

exampleBase 
  = [ ("Alice" , "Postman Pat") , ("Anna" , "All Alone") ,
      ("Alice" , "Spot") , ("Rory" , "Postman Pat") ]

||----------------------------------------------------------------------|| 
||	Types of lookup functions.					||
||----------------------------------------------------------------------|| 

books       :: database -> person -> [book]
borrowers   :: database -> book -> [person]
borrowed    :: database -> book -> bool
numBorrowed :: database -> person -> num

||----------------------------------------------------------------------|| 
||	Types of update functions.					||
||----------------------------------------------------------------------|| 

makeLoan   :: database -> person -> book -> database
returnLoan :: database -> person -> book -> database

||----------------------------------------------------------------------|| 
||	Examples:							||
||									||
||	books exampleBase "Alice" = [ "Postman Pat" , "Spot" ]		||
||	books exampleBase "Rory"  = [ "Postman Pat" ]			||
||----------------------------------------------------------------------|| 

||----------------------------------------------------------------------|| 
||	Defining books; the definitions of borrowers, borrowed and	||
||	numBorrowed are an exercise.					||
||----------------------------------------------------------------------|| 

books [] borrower = []

books ((pers,bk):rest) borrower
  = bk : books rest borrower     , if pers = borrower
  =      books rest borrower     , otherwise

||----------------------------------------------------------------------|| 
||	Defining the update functions					||
||----------------------------------------------------------------------|| 

makeLoan dBase pers bk = (pers,bk) : dBase

||----------------------------------------------------------------------|| 
||	returnLoan only removes the first pair (pers,bk).		||
||----------------------------------------------------------------------|| 

returnLoan ((p,b):rest) pers bk
  = rest                              , if p=pers & b=bk
  = (p,b) : returnLoan rest pers bk   , otherwise
returnLoan [] pers bk
  = error ("returnLoan failed on " ++ pers ++ " " ++ bk)

||----------------------------------------------------------------------|| 
||	An alternative, *different*, definition of returning a loan.	||
||	All (pers,bk) pairs are removed.				||
||----------------------------------------------------------------------|| 

returnLoan2 :: database -> person -> book -> database

returnLoan2 ((p,b):rest) pers bk
  =         returnLoan2 rest pers bk   , if p=pers & b=bk
  = (p,b) : returnLoan2 rest pers bk   , otherwise
returnLoan2 [] pers bk
  = []

||----------------------------------------------------------------------|| 
||	Testing								||
||----------------------------------------------------------------------|| 

test0 = makeLoan [] "Alice" "Fireman Sam"
test1 = borrowed exampleBase "Spot"
test2 = makeLoan exampleBase "Alice" "Fireman Sam"


