||----------------------------------------------------------------------||
||                                                                      ||
||	Section 4.5: List comprehensions				||
||                                                                      ||
||	(c) Simon Thompson, 1995.					||
||                                                                      ||
||----------------------------------------------------------------------||

||----------------------------------------------------------------------|| 
||	A series of examples.						||
||----------------------------------------------------------------------|| 

ex = [2,4,7]

exam1 = [ 2*a | a<-ex]

exam2 = [ isEven n | n<-ex ] 

exam3 = [ 2*a | a <- ex ; isEven a ; a>3 ]

||----------------------------------------------------------------------|| 
||	The isEven check.						||
||----------------------------------------------------------------------|| 

isEven :: num -> bool

isEven n = ((n mod 2) = 0) 

||----------------------------------------------------------------------|| 
||	Summing a list of pairs.					||
||----------------------------------------------------------------------|| 

sumPairs :: [(num,num)] -> [num]

sumPairs pairList = [ a+b | (a,b) <- pairList ]

||----------------------------------------------------------------------|| 
||	A variant of the previous function.				||
||----------------------------------------------------------------------|| 

newSumPairs :: [(num,num)] -> [num]

newSumPairs pairList = [ a+b | (a,b) <- pairList ; a<b ]


||----------------------------------------------------------------------|| 
||	Double every element of a list.					||
||----------------------------------------------------------------------|| 

double :: [num] -> [num]

double l = [ 2*a | a<-l ]

||----------------------------------------------------------------------|| 
||	Picking out the digits in a string.				||
||----------------------------------------------------------------------|| 

string == [char]

digits :: string -> string

digits st = [ ch | ch<-st ; digit ch ] 

||----------------------------------------------------------------------|| 
||	Revising the database functions.				||
||----------------------------------------------------------------------|| 

person == string
book   == string

database == [ (person,book) ]

books :: database -> person -> [book]

books db borrower 
  = [ bk | (per,bk) <- db ; per=borrower ]

||----------------------------------------------------------------------|| 
||	An erroneous definition of books.				||
||----------------------------------------------------------------------|| 

books' :: database -> person -> [book]

books' db borrower 
  = [ bk | (borrower,bk) <- db ]


