||----------------------------------------------------------------------||
||                                                                      ||
||	Section 4.6: Supermarket billing				||
||                                                                      ||
||	(c) Simon Thompson, 1995.					||
||                                                                      ||
||----------------------------------------------------------------------||



||----------------------------------------------------------------------|| 
||	Types of the basic components of the system.			||
||----------------------------------------------------------------------|| 

string == [char]

name    == string
price   == num
barCode == num

||----------------------------------------------------------------------|| 
||	The database storing information about names and prices		||
||	is of this type:						||
||----------------------------------------------------------------------|| 

database == [ (barCode,name,price) ]

||----------------------------------------------------------------------|| 
||	Example database.						||
||----------------------------------------------------------------------|| 

codeIndex :: database
codeIndex = [ (4719, "Fish Fingers" , 121),
              (5643, "Nappies" , 1010),
              (3814, "Orange Jelly", 56),
              (1111, "Hula Hoops", 21),
              (1112, "Hula Hoops (Giant)", 133),
              (1234, "Dry Sherry, 1lt", 540)]

||----------------------------------------------------------------------|| 
||	The types of till inputs, and of the converted information,	||
||	names and prices replacing bar codes.				||
||----------------------------------------------------------------------|| 

tillType == [barCode]
billType == [(name,price)]

||----------------------------------------------------------------------|| 
||	Principal functions of the system.				||
||----------------------------------------------------------------------|| 

makeBill   :: tillType -> billType
formatBill :: billType -> string
printBill  :: tillType -> string

printBill tt = formatBill (makeBill tt)

||----------------------------------------------------------------------|| 
||	The length of a line of the bill, defined as a constant.	||
||----------------------------------------------------------------------|| 

lineLength :: num
lineLength = 30

||----------------------------------------------------------------------|| 
||	Type declarations of formatting functions from the exercises.	||
||----------------------------------------------------------------------|| 

formatPence :: num -> string
formatLine  :: (name,price) -> string
formatLines :: [ (name,price) ] -> string
makeTotal :: billType -> num
formatTotal :: num -> string

||----------------------------------------------------------------------|| 
||	Type declarations of database functions from the exercises.	||
||----------------------------------------------------------------------|| 

look :: database -> barCode -> (name,price)
lookup :: barCode -> (name,price)

||----------------------------------------------------------------------|| 
||	Type declarations of extension functions from the exercises.	||
||----------------------------------------------------------------------|| 

makeDiscount :: billType -> num
formatDiscount :: num -> string

