||----------------------------------------------------------------------||
||                                                                      ||
||	Section 4.7: Text processing.					||
||                                                                      ||
||	(c) Simon Thompson, 1995.					||
||                                                                      ||
||----------------------------------------------------------------------||

string == [char]

||----------------------------------------------------------------------|| 
||	Example text.							||
||----------------------------------------------------------------------|| 

examT :: string

examT = "The heat bloomed     in December as the\ncarnival  season \nkicked into  gear.\nNearly helpless with sun and glare, I avoided Rio's brilliant\nsidewalks\nand glittering beaches,\npanting in dark   corners\n and waiting out the inverted southern summer."

||----------------------------------------------------------------------|| 
||	The list of whitespace characters.				||
||----------------------------------------------------------------------|| 


whitespace :: [char]

whitespace = ['\n','\t',' ']

||----------------------------------------------------------------------|| 
||	Getting a word.							||
||----------------------------------------------------------------------|| 

getWord :: string -> string

getWord []    = [] 
getWord (a:x) 
  = []              , if member whitespace a
  = a : getWord x   , otherwise 

exam1 = getWord "cat dog"


||----------------------------------------------------------------------|| 
||	Dropping a word.						||
||----------------------------------------------------------------------|| 

dropWord :: string -> string

dropWord []    = []
dropWord (a:x) 
  = (a:x)          , if member whitespace a
  = dropWord x     , otherwise

exam2 = dropWord "cat dog" 


||----------------------------------------------------------------------|| 
||	Dropping whitespace from the front of a string.			||

dropSpace :: string -> string

dropSpace []    = []
dropSpace (a:x) 
  = dropSpace x      , if member whitespace a
  = (a:x)            , otherwise


||----------------------------------------------------------------------|| 
||	Splitting into words. The top-level function calls split after	||
||	removing any white space at the sstart of the input.		||
||----------------------------------------------------------------------|| 

word == string

splitWords :: string -> [word]

splitWords x = split (dropSpace x)

split :: string -> [word]

split [] = []
split x
  = (getWord x) : split (dropSpace (dropWord x))

exam3 = splitWords "  dog cat"


||----------------------------------------------------------------------|| 
||	A line is a list of words.					||
||----------------------------------------------------------------------|| 

line == [word]

||----------------------------------------------------------------------|| 
||	Getting a line of a particular length from a list of words.	||
||----------------------------------------------------------------------|| 

getLine :: num -> [word] -> line

getLine len []     = []

getLine len (w:ws)
  = w : restOfLine  , if #w <= len
  = []              , otherwise
    where
    newlen      = len - (#w + 1)
    restOfLine  = getLine newlen ws

exam4 = getLine 20 ["Mary","Poppins","looks","like","Maria"]

||----------------------------------------------------------------------|| 
||	Dropping a line -- companion to getLine.			||
||----------------------------------------------------------------------|| 

dropLine :: num -> [word] -> [word]

||----------------------------------------------------------------------|| 
||	Splitting a list of words into a list of lines of maximum 	||
||	length lineLen.							||
||----------------------------------------------------------------------|| 

lineLen :: num

splitLines :: [word] -> [line]

splitLines [] = []
splitLines x
  = getLine lineLen x
         : splitLines (dropLine lineLen x)

||----------------------------------------------------------------------|| 
||	To fill a text, split it into words, and then into lines.	||
||----------------------------------------------------------------------|| 

fill :: string -> [line]

fill st = splitLines (splitWords st)

||----------------------------------------------------------------------|| 
||	Printing lines -- left as an exercise.				||
||----------------------------------------------------------------------|| 

printLines :: [line] -> string
printLine :: line -> string

exam5 = printLine [ "dog" , "cat" ] 

