||----------------------------------------------------------------------||
||                                                                      ||
||	Chapter 5: Reasoning about lists				||
||                                                                      ||
||	(c) Simon Thompson, 1995.					||
||                                                                      ||
||----------------------------------------------------------------------||

||----------------------------------------------------------------------|| 
||	Summing a list; doubling every element.				||
||----------------------------------------------------------------------|| 

sumList :: [num] -> num

sumList []    = 0  
sumList (b:y) = b + sumList y 

double :: [num] -> [num]

double []    = []  
double (b:y) = (2*b) : double y  


||----------------------------------------------------------------------|| 
||	Append -- pre-defined in Miranda.				||
||									||
||	[]    ++ v = v 							||
||	(c:u) ++ v = c:(u++v) 						||
||----------------------------------------------------------------------|| 


||----------------------------------------------------------------------|| 
||	Member -- pre-defined in Miranda.                               ||
||                                                                      ||
||      member []    d = False 						||
||	member (c:z) d = (c=d) \/ member z d				||
||----------------------------------------------------------------------|| 

||----------------------------------------------------------------------|| 
||	To flatten a list of lists 					||
||----------------------------------------------------------------------|| 

flatten :: [[num]] -> [num]

flatten []    = []
flatten (c:z) = c ++ flatten z

||----------------------------------------------------------------------|| 
||	Is a list of numbers sorted?					||
||----------------------------------------------------------------------|| 

sorted :: [num] -> bool

sorted []      = True
sorted [a]     = True
sorted (a:b:x) = (a<=b) & sorted (b:x)

||----------------------------------------------------------------------|| 
||	Shunting from one list to another.				||
||----------------------------------------------------------------------|| 

shunt :: [num] -> [num] -> [num]

shunt []    y = y 
shunt (a:x) y = shunt x (a:y) 

exam1 = shunt [2,3,1] []

||----------------------------------------------------------------------|| 
||	Reversing a list by shunting.					||
||----------------------------------------------------------------------|| 

rev :: [num] -> [num]

rev l = shunt l []


||----------------------------------------------------------------------|| 
||	Another reversing function.					||
||----------------------------------------------------------------------|| 

rev2 ::  [num] -> [num]

rev2 []    = []
rev2 (a:x) = rev2 x ++ [a]

||----------------------------------------------------------------------|| 
||	Auxiliary function used in a different version of the factorial	||
||	function.							||
||----------------------------------------------------------------------|| 

facAux :: num -> num -> num

facAux 0     p = p
facAux (n+1) p = facAux n ((n+1)*p)

||----------------------------------------------------------------------|| 
||	A different factorial.						||
||----------------------------------------------------------------------|| 

fac2 :: num -> num

fac2 n = facAux n 1

