||----------------------------------------------------------------------||
||                                                                      ||
||	Section 6.1: Functions as arguments				||
||                                                                      ||
||	(c) Simon Thompson, 1995.					||
||                                                                      ||
||----------------------------------------------------------------------||


||----------------------------------------------------------------------|| 
||	Mapping a numeric function along a list of numbers.		||
||----------------------------------------------------------------------|| 

mapNum :: (num -> num) -> [num] -> [num]

mapNum f []    = []
mapNum f (a:x) = f a : mapNum f x

||----------------------------------------------------------------------|| 
||	Double or treble every element of a list of numbers.		||
||----------------------------------------------------------------------|| 

double l = mapNum times2 l
treble l = mapNum times3 l

times2,times3 :: num -> num

times2 n = 2*n
times3 n = 3*n

exam1 = mapNum times2 [2,3]

||----------------------------------------------------------------------|| 
||	Alternative definition using a list comprehension.		||
||----------------------------------------------------------------------|| 

mapNum' f l = [ f a | a <-l ]

||----------------------------------------------------------------------|| 
||	A function to give the sum f 0 + ... + f n.			||
||----------------------------------------------------------------------|| 

total :: (num -> num) -> num -> num

total f n
  = f 0                     , if n=0
  = total f (n-1) + f n     , otherwise

||----------------------------------------------------------------------|| 
||	The maximum of the values f 0 , ..., f n.			||
||----------------------------------------------------------------------|| 

maxFun :: (num -> num) -> num -> num

maxFun f n
  = f 0                             , if n=0
  = max2 (maxFun f (n-1)) (f n)     , otherwise

||----------------------------------------------------------------------|| 
||	Is one of f 0 , ..., f n zero?					||
||----------------------------------------------------------------------|| 

zeroInRange :: (num -> num) -> num -> bool

zeroInRange f 0     = (f 0 = 0)
zeroInRange f (n+1) = zeroInRange f n \/ (f (n+1) = 0)

||----------------------------------------------------------------------|| 
||	Folding a numerical operator into a list of numbers.		||
||----------------------------------------------------------------------|| 

foldNum :: (num -> num -> num) -> [num] -> num

foldNum f [a]     = a
foldNum f (a:b:x) = f a (foldNum f (b:x))

||----------------------------------------------------------------------|| 
||	Using foldNum.							||
||----------------------------------------------------------------------|| 

sumList l = foldNum (+) l
maxList l = foldNum max2 l

||----------------------------------------------------------------------|| 
||	Properties of characters.					||
||----------------------------------------------------------------------|| 

isDigit, isLetter :: char -> bool

isDigit  ch = ('0'<=ch & ch<='9')
isLetter ch = ('a'<=ch & ch<='z') \/ ('A'<=ch & ch<='Z')

||----------------------------------------------------------------------|| 
||	Filtering a string for the characters with a given		||
||	property.							||
||----------------------------------------------------------------------|| 

filterString :: (char -> bool) -> [char] -> [char]

filterString p [] = []
filterString p (a:x)
  = a : filterString p x    , if p a 
  =     filterString p x    , otherwise

||----------------------------------------------------------------------|| 
||	Using filterString						||
||----------------------------------------------------------------------|| 

digits  st = filterString isDigit st
letters st = filterString isLetter st

||----------------------------------------------------------------------|| 
||	Defining filterString using a list comprehension.		||
||----------------------------------------------------------------------|| 

filterString' p x = [ a | a<-x ; p a ]

