||----------------------------------------------------------------------||
||                                                                      ||
||	Section 6.3: Putting the two together				||
||                                                                      ||
||	(c) Simon Thompson, 1995.					||
||                                                                      ||
||----------------------------------------------------------------------||


||----------------------------------------------------------------------|| 
||	Examples using map.						||
||----------------------------------------------------------------------|| 

exam1 = map times2 [2,3,4] 
exam2 = map isEven [2,3,4] 
exam3 = map small "Bongo Fury" 
exam4 = map (#) ["Clear","Spot"] 

times2 n = 2*n

small :: char -> char

||----------------------------------------------------------------------|| 
||	Folding								||
||----------------------------------------------------------------------|| 

fold :: (* -> * -> *) -> [*] -> *

fold f [a]     = a
fold f (a:b:x) = f a (fold f (b:x))

||----------------------------------------------------------------------|| 
||	Examples using fold.						||
||----------------------------------------------------------------------|| 

exam5 = fold (\/) [False,True,False] 
exam6 = fold (++) ["Freak ", "Out" , "", "!"] 
exam7 = fold min2 [6]
exam8 = fold (*) [1..6] 


||----------------------------------------------------------------------|| 
||	Defining reverse using foldr.					||
||----------------------------------------------------------------------|| 

rev' :: [*] -> [*]

rev' l = foldr stick [] l

stick :: * -> [*] -> [*]

stick a x = x ++ [a]

||----------------------------------------------------------------------|| 
||	Examples using filter.						||
||----------------------------------------------------------------------|| 

exam9 =filter isEven [2,3,4] 
exam10 = filter nonEmpty ["Freak ", "Out" , "", "!"] 

isEven :: num -> bool
isEven m = (m mod 2 = 0)

nonEmpty l = (l~=[])
