||----------------------------------------------------------------------||
||                                                                      ||
||	Section 6.4: Using the higher-order functions			||
||                                                                      ||
||	(c) Simon Thompson, 1995.					||
||                                                                      ||
||----------------------------------------------------------------------||

||----------------------------------------------------------------------|| 
||	Type definitions used.						||
||----------------------------------------------------------------------|| 

string == [char]
book == string
person == string
database == [ (person,book) ]

||----------------------------------------------------------------------|| 
||	Redefining database functions.					||
||----------------------------------------------------------------------|| 

books :: database -> person -> [book]

books db per = map snd (filter isPer db)
               where
               isPer (p,b) = (p = per)


returnLoan :: database -> person -> book -> database

returnLoan db p b 
  = filter notPB db
    where
    notPB pr = (pr ~= (p,b))

||----------------------------------------------------------------------|| 
||	Exercise function declarations.					||
||----------------------------------------------------------------------|| 

filterFirst :: (* -> bool) -> [*] -> [*]
filterLast  :: (* -> bool) -> [*] -> [*]


