||----------------------------------------------------------------------||
||                                                                      ||
||	Section 6.5: Generalizing: splitting up lists			||
||                                                                      ||
||	(c) Simon Thompson, 1995.					||
||                                                                      ||
||----------------------------------------------------------------------||

||----------------------------------------------------------------------|| 
||	Take and drop -- pre-defined.					||
||	take, drop :: num -> [*] -> [*]					||
||									||
||	take n []        = []						||
||	take 0 l         = []						||
||	take (n+1) (a:x) = a : take n x					||
||----------------------------------------------------------------------|| 

||----------------------------------------------------------------------|| 
||	Getting elements from the front of a list while they do not	||
||	belong to a split set.						||
||----------------------------------------------------------------------|| 

getFront :: [*] -> [*] -> [*]

getFront splitSet []    = [] 
getFront splitSet (a:x) 
  = []                        , if member splitSet a
  = a : getFront splitSet x   , otherwise 

||----------------------------------------------------------------------|| 
||	Getting elements from the front of a list until a condition 	||
||	holds.								||
||----------------------------------------------------------------------|| 

getUntil :: (* -> bool) -> [*] -> [*]

getUntil p []    = [] 
getUntil p (a:x) 
  = []                 , if p a
  = a : getUntil p x   , otherwise 

