||----------------------------------------------------------------------||
||                                                                      ||
||	Section 7.2: Functions as results				||
||                                                                      ||
||	(c) Simon Thompson, 1995.					||
||                                                                      ||
||----------------------------------------------------------------------||


||----------------------------------------------------------------------|| 
||	Apply a function twice.						||
||----------------------------------------------------------------------|| 

twice :: (* -> *) -> (* -> *)

twice f = f.f

exam1 = (twice succ) 12

succ n = n+1

||----------------------------------------------------------------------|| 
||	Apply the function n times.					||
||----------------------------------------------------------------------|| 

iter :: num -> (* -> *) -> (* -> *)

iter 0 f     = id
iter (n+1) f = f . iter n f

||----------------------------------------------------------------------|| 
||	Return a function adding the given number to its argument.	||
||----------------------------------------------------------------------|| 

addNum :: num -> (num -> num)
addNum n = h
           where
           h m = n+m

||----------------------------------------------------------------------|| 
||	Apply f to the two values before sending to g.			||
||----------------------------------------------------------------------|| 

comp2 f g = h
            where
            h x y = g (f x) (f y)

exam2 = comp2 sq add 3 4

sq n = n*n

add a b = a+b

||----------------------------------------------------------------------|| 
||	Exercise functions.						||
||----------------------------------------------------------------------|| 

total :: (num -> num) -> (num -> num)
slope :: (num -> num) -> (num -> num)
integrate :: (num -> num) -> (num -> num -> num)
 
