||----------------------------------------------------------------------||
||                                                                      ||
||	Section 7.5: Currying and uncurrying				||
||                                                                      ||
||	(c) Simon Thompson, 1995.					||
||                                                                      ||
||----------------------------------------------------------------------||

||----------------------------------------------------------------------|| 
||	An 'uncurried' version of multiplication.			||
||----------------------------------------------------------------------|| 

multiplyUC :: (num,num) -> num

multiplyUC (a,b) = a*b

||----------------------------------------------------------------------|| 
||	Go from uncurried to curried.					||
||----------------------------------------------------------------------|| 

curry :: ((*,**) -> ***) -> (* -> ** -> ***)

curry g a b = g (a,b)

||----------------------------------------------------------------------|| 
||      Go from curried to uncurried.                                   ||
||----------------------------------------------------------------------|| 

uncurry :: (* -> ** -> ***) -> ((*,**) -> ***)

uncurry f (a,b) = f a b

||----------------------------------------------------------------------|| 
||	Swap the order of arguments to a curried function.		||
||----------------------------------------------------------------------|| 

converse' :: (* -> ** -> ***) -> (** -> * -> ***)

converse' f b a = f a b

