||----------------------------------------------------------------------||
||                                                                      ||
||	Section 9.1: Introduction.					||
||                                                                      ||
||	(c) Simon Thompson, 1995.					||
||                                                                      ||
||----------------------------------------------------------------------||

||----------------------------------------------------------------------|| 
||	Enumerated (weather) types.					||
||----------------------------------------------------------------------|| 

temp   ::= Cold | Hot

season ::= Spring | Summer | Autumn | Winter

||----------------------------------------------------------------------|| 
||	What is the weather?						||
||----------------------------------------------------------------------|| 

weather :: season -> temp

weather Summer = Hot
weather x      = Cold

||----------------------------------------------------------------------|| 
||	Booleans can be defined thus:					||
||		bool ::= False | True					||
||----------------------------------------------------------------------|| 

||----------------------------------------------------------------------|| 
||	Product types.							||
||----------------------------------------------------------------------|| 

||----------------------------------------------------------------------|| 
||	A type of people.						||
||----------------------------------------------------------------------|| 

people ::= Person name age 

string == [char]
name   == string
age    == num

exam1 = Person "Electric Aunt Jemima" 77
exam2 = Person "Ronnie" 14

||----------------------------------------------------------------------|| 
||	Printing an object of type people.				||
||----------------------------------------------------------------------|| 

showPerson :: people -> string

showPerson (Person n a) = n ++ " -- " ++ shownum a

exam3 = showPerson (Person "Electric Aunt Jemima" 77)

||----------------------------------------------------------------------|| 
||	An alternative definition of the type of people is given by 	||
||		people == (name,age)					||
||----------------------------------------------------------------------|| 

||----------------------------------------------------------------------|| 
||	A unary constructor						||
||----------------------------------------------------------------------|| 

newAge ::= Years num

||----------------------------------------------------------------------|| 
||	Alternatives							||
||----------------------------------------------------------------------|| 

||----------------------------------------------------------------------|| 
||	A type of shapes.						||
||----------------------------------------------------------------------|| 

shape ::= Circle num | Rectangle num num

exam4 = Circle 3
exam5 = Rectangle 45.9 87.6

||----------------------------------------------------------------------|| 
||	Example functions over shape.					||
||----------------------------------------------------------------------|| 

isRound :: shape -> bool

isRound (Circle r)      = True
isRound (Rectangle h w) = False

area :: shape -> num

area (Circle r)      = pi*r*r
area (Rectangle h w) = h*w


