||----------------------------------------------------------------------||
||                                                                      ||
||	Section 9.2: Recursive Types					||
||                                                                      ||
||	(c) Simon Thompson, 1995.					||
||                                                                      ||
||----------------------------------------------------------------------||


||----------------------------------------------------------------------|| 
||	A type of arithmetic expressions.				||
||----------------------------------------------------------------------|| 

expr ::= Lit num |
         Add expr expr |
         Sub expr expr

||----------------------------------------------------------------------|| 
||      A type of numerical trees.					||
||----------------------------------------------------------------------|| 

nTree::= NilT |
         Node num nTree nTree

||----------------------------------------------------------------------|| 
||	Examples of expressions.					||
||----------------------------------------------------------------------|| 

exam1 = Lit 2
exam2 = Add (Lit 2) (Lit 3)
exam3 = Add (Sub (Lit 3) (Lit 1)) (Lit 3)  

||----------------------------------------------------------------------|| 
||	Expression evaluation.						||
||----------------------------------------------------------------------|| 

eval :: expr -> num

eval (Lit n)     = n
eval (Add e1 e2) = (eval e1) + (eval e2)
eval (Sub e1 e2) = (eval e1) - (eval e2)

||----------------------------------------------------------------------|| 
||	Printing an expression.						||
||----------------------------------------------------------------------|| 

showExpr :: expr -> string

showExpr (Lit n) = shownum n
showExpr (Add e1 e2) 
  = "(" ++ showExpr e1 ++ "+" ++ showExpr e2 ++ ")"
showExpr (Sub e1 e2) 
  = "(" ++ showExpr e1 ++ "-" ++ showExpr e2 ++ ")"

||----------------------------------------------------------------------|| 
||	Example: trees of numbers					||
||----------------------------------------------------------------------|| 

exam4 = Node 10 NilT NilT
exam5 = Node 17 (Node 14 NilT NilT) (Node 20 NilT NilT)

||----------------------------------------------------------------------|| 
||	Example definitions over trees.					||
||----------------------------------------------------------------------|| 

sumTree,depth :: nTree -> num

sumTree NilT          = 0
sumTree (Node n t t') = n + sumTree t + sumTree t'

depth NilT            = 0
depth (Node n t t')   = 1 + max2 (depth t) (depth t')

exam6 = sumTree (Node 3 (Node 4 NilT NilT) NilT) 
exam7 = depth (Node 3 (Node 4 NilT NilT) NilT) 

||----------------------------------------------------------------------|| 
||	How many times does a number appear in a tree?			||
||----------------------------------------------------------------------|| 

occurs :: nTree -> num -> num

occurs NilT p = 0
occurs (Node n t t') p
     = 1 + occurs t p + occurs t' p   , if n=p
     =     occurs t p + occurs t' p   , otherwise

||----------------------------------------------------------------------|| 
||	Example: rearranging expressions				||
||----------------------------------------------------------------------|| 

assoc :: expr -> expr

assoc (Add (Add e1 e2) e3)
  = assoc (Add e1 (Add e2 e3)) 

assoc (Add e1 e2) 
  = Add (assoc e1) (assoc e2) 
assoc (Sub e1 e2) 
  = Sub (assoc e1) (assoc e2)
assoc (Lit n) 
  = Lit n

||----------------------------------------------------------------------|| 
||	Mutual Recursion						||
||----------------------------------------------------------------------|| 

||----------------------------------------------------------------------|| 
||	Declaring an object to be of type 				||
||		type							||
||	allows us to develop a program using the type before the 	||
||	type itself has been defined.					||
||----------------------------------------------------------------------|| 

name,address :: type

person ::= Adult name address biog |
           Child name

biog   ::= Parent string [person] |
           NonParent string

||----------------------------------------------------------------------|| 
||	Printing persons and biographies.				||
||----------------------------------------------------------------------|| 

string == [char]

showPerson :: person -> string

showPerson (Adult nm ad bio) 
  = showName nm ++ showAddress ad ++ showBiog bio

showBiog :: biog -> string

showBiog (Parent st perList)
  = st ++ concat (map showPerson perList)

showName :: name -> string
showAddress :: address -> string

||----------------------------------------------------------------------|| 
||	From the exercises...						||
||----------------------------------------------------------------------|| 

size :: expr -> num

||----------------------------------------------------------------------|| 
||	A new definiton of expr.					||
||									||
||	expr ::= Lit num |						||
||		 Op op expr expr |					||
||               If bExp expr expr					||
||									||
||	op ::= Add | Sub | Mul | Div 					||
||									||
||----------------------------------------------------------------------|| 

||----------------------------------------------------------------------|| 
||	Boolean expressions.						||
||----------------------------------------------------------------------|| 

bExp ::= BoolLit bool |
         And bExp bExp |
         Not bExp |
         Equal expr expr |
         Greater expr expr

bEval :: bExp -> bool


