||----------------------------------------------------------------------||
||                                                                      ||
||	Section 9.3: Polymorphic algebraic types			||
||                                                                      ||
||	(c) Simon Thompson, 1995.					||
||                                                                      ||
||----------------------------------------------------------------------||


||----------------------------------------------------------------------|| 
||	A pair of elements of the same type.				||
||----------------------------------------------------------------------|| 

pair * ::= Pair * *

exam1 = Pair 2 3    
exam2 = Pair [] [3]
exam3 = Pair [] []

||----------------------------------------------------------------------|| 
||	Are the two halves of the pair equal?				||
||----------------------------------------------------------------------|| 

equalPair :: pair * -> bool
equalPair (Pair x y) = (x=y)

||----------------------------------------------------------------------|| 
||	Do-it-yourself lists.						||
||----------------------------------------------------------------------|| 

list * ::= NilList | Cons * (list *)

||----------------------------------------------------------------------|| 
||	Example: Binary trees						||
||----------------------------------------------------------------------|| 

tree * ::= Nil | Node * (tree *) (tree *)

||----------------------------------------------------------------------|| 
||	The depth of a tree.						||
||----------------------------------------------------------------------|| 

depth :: tree * -> num

depth Nil           = 0
depth (Node n t t') = 1 + max2 (depth t) (depth t')

||----------------------------------------------------------------------|| 
||	Collapsing a tree to a list.					||
||----------------------------------------------------------------------|| 

collapse :: tree * -> [*]
collapse Nil = []
collapse (Node v t t')
  = collapse t ++ [v] ++ collapse t'

exam4 =
      collapse (Node 12 
               (Node 34 Nil Nil) 
               (Node 3 (Node 17 Nil Nil) Nil))

||----------------------------------------------------------------------|| 
||	Apply a function to each element of a tree.			||
||----------------------------------------------------------------------|| 

mapTree :: (* -> **) -> tree * -> tree **

mapTree f Nil = Nil
mapTree f (Node v t t')
  = Node (f v) (mapTree f t) (mapTree f t')

||----------------------------------------------------------------------|| 
||	Example: union type						||
||----------------------------------------------------------------------|| 

union * ** ::= One * | Two **

exam5 = One "Duke of Prunes" 
exam6 = Two 333.12345       

||----------------------------------------------------------------------|| 
||	Is an element in the first half of the union?			||
||----------------------------------------------------------------------|| 

isOne :: union * ** -> bool

isOne (One x) = True
isOne (Two x) = False

||----------------------------------------------------------------------|| 
||	Joining functions to work over a union.				||
||----------------------------------------------------------------------|| 

joinFuns :: (* -> ***) -> (** -> ***) -> union * ** -> ***

joinFuns f g (One v) = f v
joinFuns f g (Two v) = g v

||----------------------------------------------------------------------|| 
||	Applying a function applicable to * to an element of type	||
||		union * **						||
||----------------------------------------------------------------------|| 

applyOne :: (* -> ***) -> union * ** -> ***

applyOne f (One x) = f x
applyOne f (Two y) = error "applyOne applied to Two!"

||----------------------------------------------------------------------|| 
||	Exercise functions...						||
||----------------------------------------------------------------------|| 

jFuns :: (* -> ***) -> (** -> ****) -> 
         union * ** -> union *** ****

gTree * ::= Leaf * | Gnode [gTree *]

