||----------------------------------------------------------------------||
||                                                                      ||
||	Section 9.4: Case study: Program Errors				||
||                                                                      ||
||	(c) Simon Thompson, 1995.					||
||                                                                      ||
||----------------------------------------------------------------------||

||----------------------------------------------------------------------|| 
||	The built in error function.					||
||		error :: [char] -> *					||
||----------------------------------------------------------------------|| 

||----------------------------------------------------------------------|| 
||	Dummy values in a tail function.				||
||----------------------------------------------------------------------|| 

tail :: [*] -> [*]

tail (a:x) = x
tail []    = []

||----------------------------------------------------------------------|| 
||	Dummy values in a division function.				||
||----------------------------------------------------------------------|| 

divide :: num -> num -> num

divide n m = n/m   , if m ~= 0
           = 0     , otherwise

||----------------------------------------------------------------------|| 
||	A dummy value from the head function is passed in as an 	||
||	extra parameter.						||
||----------------------------------------------------------------------|| 

head :: * -> [*] -> *

head b (a:x) = a
head b []    = b

||----------------------------------------------------------------------|| 
||	Error types							||
||----------------------------------------------------------------------|| 

err * ::= OK * | Error

||----------------------------------------------------------------------|| 
||	Division returning a value of type err num.			||
||----------------------------------------------------------------------|| 

errDiv :: num -> num -> err num

errDiv n m = OK (n/m)    , if m ~= 0
           = Error       , otherwise

||----------------------------------------------------------------------|| 
||	Lift a function so that it transmits errors from input to 	||
||	output.								||
||----------------------------------------------------------------------|| 

lift :: (*->**)->err *->err **

lift g Error  = Error
lift g (OK x) = OK (g x)

||----------------------------------------------------------------------|| 
||	Trapping and handling an error.					||
||----------------------------------------------------------------------|| 

trap::(*->**)->**->err *->**

trap f v (OK x) = f x
trap f v Error  = v

exam1 = trap (1+) 56 (lift (*3) (errDiv 9 0)) 
exam2 = trap (1+) 56 (lift (*3) (errDiv 9 1))  

||----------------------------------------------------------------------|| 
||	 Functions from the exercises...				||
||----------------------------------------------------------------------|| 

process :: [num] -> num -> num -> num

squash :: err (err *) -> err *

composeErr :: (* -> err **) -> (** -> err ***) -> (* -> err ***)

||----------------------------------------------------------------------|| 
||	Generalising the type of errors to include an error message.	||
||----------------------------------------------------------------------|| 

string == [char]

newErr * ::= NewOK * | NewError string



