||----------------------------------------------------------------------||
||                                                                      ||
||	Section 9.5: Design with Algebraic Data Types			||
||                                                                      ||
||	(c) Simon Thompson, 1995.					||
||                                                                      ||
||----------------------------------------------------------------------||

||----------------------------------------------------------------------|| 
||	Edit distance							||
||----------------------------------------------------------------------|| 

||----------------------------------------------------------------------|| 
||	The type of editing operations.					||
||----------------------------------------------------------------------|| 

edit ::= Change char |
          Copy |
          Delete |
          Insert char |
          Kill  

string == [char]

||----------------------------------------------------------------------|| 
||	Transforming a string into another -- gives a sequence of edits	||
||----------------------------------------------------------------------|| 

transform :: string -> string -> [edit]

transform [] [] = []
transform st [] = [Kill]
transform [] st = map Insert st

transform (a:x) (b:y)
  = Copy : transform x y                    , if a=b
  = best [ Delete   : transform x (b:y) ,
           Insert b : transform (a:x) y ,
           Change b : transform x y     ]   , otherwise

||----------------------------------------------------------------------|| 
||	Finding the best (lowest cost) sequence of edits in a 		||
||	list of such.							||
||----------------------------------------------------------------------|| 

best :: [[edit]] -> [edit]

best [a]   = a
best (a:x) = a     , if cost a <= cost b
           = b     , otherwise
             where 
             b = best x

||----------------------------------------------------------------------|| 
||	The cost of a given sequence -- count one for all but the 	||
||	copy operation.							||
||----------------------------------------------------------------------|| 

cost :: [edit] -> num

cost = (#) . filter (~=Copy)

||----------------------------------------------------------------------|| 
||	Example: Simulation						||
||----------------------------------------------------------------------|| 

||----------------------------------------------------------------------|| 
||	Incoming messages.						||
||----------------------------------------------------------------------|| 

inmess ::= No | Yes arrival service

arrival == num
service == num

||----------------------------------------------------------------------|| 
||	Outgoing messages.						||
||----------------------------------------------------------------------|| 

outmess ::= None | Discharge arrival wait service

wait == num

