||----------------------------------------------------------------------||
||                                                                      ||
||	interact.m	A library of interactions.			||
||									||
||	See Chapter 13 for details.					||
||                                                                      ||
||	(c) Simon Thompson, 1995.					||
||                                                                      ||
||----------------------------------------------------------------------||

||----------------------------------------------------------------------|| 
||	The type of conditions.						||
||----------------------------------------------------------------------|| 

condition * == (input,*) -> bool

||----------------------------------------------------------------------|| 
||	The abstype of interactions.					||
||----------------------------------------------------------------------|| 


abstype
  interact * **
with
  apply :: (* -> **) -> interact * **
  readI :: (string -> * -> **) -> interact * **
  write :: (* -> string) -> interact * *
  sq    :: interact * ** -> interact ** *** -> interact * ***
  alt   :: condition * -> 
           interact * ** -> interact * ** -> interact * **
  run   :: interact * ** -> * -> [char]

||----------------------------------------------------------------------|| 
||	The implementation type						||
||----------------------------------------------------------------------|| 

interact * ** == (input,*) -> (input,**,output)

string == [char]
input  == [string]
output == [string]

||----------------------------------------------------------------------|| 
||	Note that the input and output types here are lists of lines. 	||
||----------------------------------------------------------------------|| 

||----------------------------------------------------------------------|| 
||	The implementation functions.					||
||----------------------------------------------------------------------|| 

||	apply :: (* -> **) -> interact * **

apply f (in,st) = (in, f st , [])

||	readI :: (string -> * -> **) -> interact * **
 
readI f (line:rest,st) = (rest, f line st, [])

||	write :: (* -> string) -> interact * *
 
write f (in,st) = ( in , st , [ f st ] )

||	sq :: interact * ** -> interact ** *** -> interact * ***

sq inter1 inter2 (in,st)
  = (rest2,st2,out1++out2)
    where
    (rest1,st1,out1) = inter1 (in,st)
    (rest2,st2,out2) = inter2 (rest1,st1)

||	alt :: condition * -> 
||		interact * ** -> interact * ** -> interact * **

alt cond inter1 inter2 x
  = inter1 x                 , if cond x
  = inter2 x                 , otherwise

||	run :: interact * ** -> * -> [char]

run inter st
  = lay out
    where
    (rest,st',out) = inter (lines (read stdin) , st)

stdin = "/dev/tty"

||----------------------------------------------------------------------|| 
||	Examples using the abstype.					||
||----------------------------------------------------------------------|| 

oneStep :: interact * num
oneStep =
  readI (const . numval) $sq 
  apply (+1) $sq 
  write shownum

||----------------------------------------------------------------------|| 
||	A while loop							||
||----------------------------------------------------------------------|| 

while ::  condition * -> interact * * -> interact * *

while cond inter 
  = whi
    where
    whi = alt cond (inter $sq whi) null

||----------------------------------------------------------------------|| 
||	A null interaction: no I/O, no change of state.			||
||----------------------------------------------------------------------|| 

null :: interact * *

null = apply id

||----------------------------------------------------------------------|| 
||	End of file?							||
||----------------------------------------------------------------------|| 

eof :: condition *

eof (in,st) = (in=[])


