
||----------------------------------------------------------------------||
||                                                                      ||
||      basicOperations.m                                               ||
||                                                                      ||
||      Basic operations on a queue and a server: a queue list.         ||
||                                                                      ||
||      August 1994                                                     ||
||                                                                      ||
||----------------------------------------------------------------------||

%include "types"
%include "concTypes"

%export serverStep addToQueue

||----------------------------------------------------------------------||
||      One queue step -- process the front element.                    ||
||      Two cases:                                                      ||
||              If not fully served, increment serviceSoFar;            ||
||              if fully served, remove from queue and generate         ||
||              appropriate output message.                             ||
||----------------------------------------------------------------------||

queueStep :: queueState -> ( queueState , [outmess] )

queueStep (time,serv,[]) = ( (time+1,serv,[]) , [] )

queueStep ( time , servSoFar , Yes a serv : inRest )
        = ( (time+1, servSoFar+1 , Yes a serv : inRest ) , [] )
                                                , if servSoFar < serv
        = ( (time+1, 0 , inRest) , [Discharge a (time-serv-a) serv] )
                                                , otherwise

||----------------------------------------------------------------------||
||      Process a server.                                               ||
||      Process each queue separately, and accumulate output messages.  ||
||----------------------------------------------------------------------||

serverStep :: serverState -> ( serverState , [outmess] )

serverStep [] = ( [],[] )
serverStep (q:qs) = ( q' : qs' , mess ++ messes )
                    where
                    ( q' , mess ) = queueStep q
                    ( qs' , messes ) = serverStep qs

||----------------------------------------------------------------------||
||      Add the message im to the queue at index n in serverState st.   ||
||----------------------------------------------------------------------||

addToQueue :: num -> inmess -> serverState -> serverState

addToQueue n im st
        = take n st ++ [newQueueState] ++ drop (n+1) st
          where
          newQueueState = (a,b,messlist++[im])
          (a,b,messlist) = st ! n

