||----------------------------------------------------------------------||
||                                                                      ||
||      feeder.m                                                        ||
||                                                                      ||
||      A feeder-based server. There is a single feeder queue which     ||
||      supplies objects to the individual queues only when they are    ||
||      empty.                                                          ||
||                                                                      ||
||      May 1994                                                        ||
||                                                                      ||
||----------------------------------------------------------------------||

%include "random"
%include "types"
%include "concTypes"
%include "basicOperations"
%include "inits"

||----------------------------------------------------------------------||
||      A feeder is a server with an extra queue.                       ||
||----------------------------------------------------------------------||

feederState == ( serverState , [inmess] )

||----------------------------------------------------------------------||
||      One processing step of the feeder -- apply serverStep,          ||
||      effectively.                                                    ||
||----------------------------------------------------------------------||

feederStep :: feederState -> ( feederState , [outmess] )

feederStep ( sSt , ims )
        = (( sSt' , ims ) , oms )
          where
          ( sSt' , oms ) = serverStep sSt

||----------------------------------------------------------------------||
||      Add to feeder queue.                                            ||
||----------------------------------------------------------------------||

addToFeeder :: inmess -> feederState -> feederState

addToFeeder No fSt = fSt
addToFeeder (Yes arr wait) ( sSt , ims )
        = ( sSt , ims ++ [Yes arr wait] )

||----------------------------------------------------------------------||
||      Add a new object to each of the queues which is empty.          ||
||----------------------------------------------------------------------||

addObjects :: feederState -> feederState

addObjects ( sSt , [] ) = ( sSt , [] )
addObjects ( [] , ims ) = ( [] , ims )

addObjects ( (q:qs) , ims )
        = ( q' : qs' , remains )
          where
          q' = addToQ (hd ims) q                , if queueEmpty q
             = q                                , otherwise
          ( qs' , remains )
              = addObjects ( qs , tl ims )              , if queueEmpty q
              = addObjects ( qs , ims )                 , otherwise

||----------------------------------------------------------------------||
||      Is a queue empty?                                               ||
||----------------------------------------------------------------------||

queueEmpty :: queueState -> bool

queueEmpty (w,s,q)  = (q=[])

||----------------------------------------------------------------------||
||      Add a mesage to the end of the queue part of a queueState.      ||
||----------------------------------------------------------------------||

addToQ :: inmess -> queueState -> queueState

addToQ im (w,s,q) = (w,s,q++[im])

||----------------------------------------------------------------------||
||      One step of the simulation:                                     ||
||              - do one step of processing at each queue,              ||
||              - add the input message to the feeder queue, and,       ||
||              - pass an object to each queue that is empty.           ||
||----------------------------------------------------------------------||

simStep :: feederState -> inmess -> (feederState,[outmess])

simStep fSt im
        = ( fSt3 , oms )
          where
          ( fSt1 , oms ) = feederStep fSt
          fSt2 = addToFeeder im fSt1
          fSt3 = addObjects fSt2

||----------------------------------------------------------------------||
||      Do the feeder simulation.                                       ||
||----------------------------------------------------------------------||

doSim :: feederState -> [inmess] -> [outmess]

doSim fSt [] = []
doSim fSt (im:messes)
        = outmesses ++ doSim fSt1 messes
          where
          ( fSt1 , outmesses ) = simStep fSt im

||----------------------------------------------------------------------||
||      Start state of feeder.                                          ||
||----------------------------------------------------------------------||

feederStart = ( serverStart , [] )

||----------------------------------------------------------------------||
||      Running an example.                                             ||
||----------------------------------------------------------------------||

fsim = take 50 (doSim feederStart arrivals2)

fexample = concat ( map ((++"\n").show) fsim )

ftotalWait
          = sum (map waitTime fsim)
            where
            waitTime (Discharge a w s) = w

||----------------------------------------------------------------------||
||      It is interesting to compare the difference between ftotalWait  ||
||      and totalWait. The latter will always be larger, but when the   ||
||      distrubution is only with small waiting times, the difference   ||
||      is negligible. When some substantial waiting times are added,   ||
||      the difference becomes dramatic.                                ||
||      Presumably, the difference could be greater if multiple arrivals||
||      were allowed.                                                   ||
||----------------------------------------------------------------------||
