
||----------------------------------------------------------------------||
||                                                                      ||
||      queue.m 		                                        ||
||                                                                      ||
||      The abstype of queues.						||
||                                                                      ||
||      August 1994                                                     ||
||                                                                      ||
||----------------------------------------------------------------------||

%include "types"

abstype 
  queueState
with
  queueStep   :: queueState -> ( queueState , [outmess] )
  queueStart  :: queueState
  queueLength :: queueState -> num
  addMessage  :: inmess -> queueState -> queueState
  queueEmpty  :: queueState -> bool

queueState == (time,service,[inmess])

||----------------------------------------------------------------------||
||	Implementation of queueState					||
||----------------------------------------------------------------------||

||----------------------------------------------------------------------||
||      One queue step -- process the front element.                    ||
||      Two cases:                                                      ||
||              If not fully served, increment serviceSoFar;            ||
||              if fully served, remove from queue and generate         ||
||              appropriate output message.                             ||
||----------------------------------------------------------------------||

queueStep (time,serv,[]) = ( (time+1,serv,[]) , [] )

queueStep ( time , servSoFar , Yes a serv : inRest )
        = ( (time+1, servSoFar+1 , Yes a serv : inRest ) , [] )
                                                , if servSoFar < serv
        = ( (time+1, 0 , inRest) , [Discharge a (time-serv-a) serv] )
                                                , otherwise

||----------------------------------------------------------------------||
||	Initial state of a queue.					||
||----------------------------------------------------------------------||

queueStart =  (0,0,[])

||----------------------------------------------------------------------||
||	Queue length							||
||----------------------------------------------------------------------||

queueLength (time,serv,l) = #l

||----------------------------------------------------------------------||
||	Adding a message to a queue.					||
||----------------------------------------------------------------------||

addMessage im (time,serv,messlist) = (time,serv,messlist++[im])

||----------------------------------------------------------------------||
||      Is a queue empty?                                               ||
||----------------------------------------------------------------------||

queueEmpty (w,s,q)  = (q=[])
