||----------------------------------------------------------------------||
||                                                                      ||
||      random.m                                                        ||
||                                                                      ||
||      Generating pseuso-random numbers by a linear congruence.        ||
||      Figures from Grogono pp 135-7.                                  ||
||                                                                      ||
||      The variants provide a nice example of how filters (in the      ||
||      sense of Software Tools ...) are used.                          ||
||                                                                      ||
||      May 1994                                                        ||
||                                                                      ||
||----------------------------------------------------------------------||

seed       = 17489
seed2      = 38291
multiplier = 25173
increment  = 13849
modulus    = 65536

||----------------------------------------------------------------------||
||      A good pseudo-random sequence of numbers between 0 and 65535.   ||
||----------------------------------------------------------------------||

randomSequence :: num -> [num]

randomSequence seed 
        = seed : randomSequence ((multiplier*seed + increment) mod modulus)

||----------------------------------------------------------------------||
||      Restricting the numbers to the range a to b inclusive. It is    ||
||      better to generate the restructed numbers from the most-        ||
||      significant digits rather than the least signifcant.            ||
||      The function is seeded by a number in [0..modulus-1].           ||
||----------------------------------------------------------------------||

randomRange :: num -> num -> num -> [num]

randomRange seed a b 
        = map scale (randomSequence seed)
          where
          range = b-a+1
          denom = modulus div range
          scale n = n div denom + a

||----------------------------------------------------------------------||
||      A discrete (finite) distribution of objects in * can be         ||
||      represented by a list [ (*,num) ]. The presence of (ob,p)       ||
||      means that object ob occurs with probability p.                 ||
||      It is assumed that the sum of the probs in the list is 1.       ||
||      The function is seeded by a number in [0..modulus-1].           ||
||----------------------------------------------------------------------||

randomDistrib :: num -> [ (*,num) ] -> [*]

randomDistrib seed dis
        = map scale (randomSequence seed)
          where
          scale = makeFun dis 0

||----------------------------------------------------------------------||
||      Turn a distribution into a function from [0..modulus-1] to      ||
||      the set of objects in the distribution.                         ||
||      The numerical value is used to carry the lower bound for the    ||
||      part of the distribution to come; it is initially zero.         ||
||      No checking is made of whether the probabilities add up to one. ||
||----------------------------------------------------------------------||

makeFun :: [ (*,num) ] -> num -> (num -> *)

makeFun ((ob,p):dist) nLast n
         = ob                           , if nNext >= n > nLast
         = makeFun dist nNext n         , otherwise
           where
           nNext = p*modulus + nLast
makeFun [] nLast n 
         = undef

