||----------------------------------------------------------------------||
||                                                                      ||
||      robin.m                                                         ||
||                                                                      ||
||      Modification of server.m; uses round-robin scheduling.          ||
||      The modification builds on server.m, in a way similar to        ||
||      feeder.m                                                        ||
||                                                                      ||
||      May 1994                                                        ||
||                                                                      ||
||----------------------------------------------------------------------||

%include "types"
%include "concTypes"
%include "basicOperations"
%include "inits"
||      %include "server" -addNewObject

||----------------------------------------------------------------------||
||      The state of a server with round-robin scheduling is a          ||
||      serverState together with a record of the next queue to which   ||
||      allocation will take place.                                     ||
||----------------------------------------------------------------------||

robinState == (num,serverState)

||----------------------------------------------------------------------||
||      Add an new object to be processed to the next queue, as given   ||
||      by the num field of the robinState.                             ||
||----------------------------------------------------------------------||

addNewObject :: inmess -> robinState -> robinState

addNewObject No robinSt = robinSt

addNewObject (Yes arr wait) (next,servSt)
        = ((next+1) mod noQueues , addToQueue next (Yes arr wait) servSt)
          where
          noQueues = # servSt

||----------------------------------------------------------------------||
||      Process by one unit, then add new object, if any; "compose"     ||
||      serverStep and addNewObject, in other words.                    ||
||----------------------------------------------------------------------||

simStep :: robinState -> inmess -> (robinState , [outmess])

simStep (next,servSt) im 
        = ( addNewObject im robinSt1 , outmess )
          where
          ( servSt1 , outmess ) = serverStep servSt
          robinSt1 = ( next , servSt1 )

||----------------------------------------------------------------------||
||      The simulation itself: process the stream of input messages     ||
||      into a stream of output messages by repeatedly applying the     ||
||      simulationStep function, and accumulating the list of output    ||
||      messages produced.                                              ||
||----------------------------------------------------------------------||

doSim :: robinState -> [inmess] -> [outmess]

doSim robinSt [] = []
doSim robinSt (im:messes)
        = outmesses ++ doSim robinSt1 messes
          where
          ( robinSt1 , outmesses ) = simStep robinSt im
||----------------------------------------------------------------------||
||      Start state of server.                                          ||
||----------------------------------------------------------------------||


robinStart = ( 0 , serverStart )

||----------------------------------------------------------------------||
||      Running an example.                                             ||
||----------------------------------------------------------------------||

rsim = take 50 (doSim robinStart arrivals2)

rexample = concat ( map ((++"\n").show) rsim )

rtotalWait = sum (map waitTime rsim)
             where
             waitTime (Discharge a w s) = w
