||----------------------------------------------------------------------||
||                                                                      ||
||      server.m                                                        ||
||                                                                      ||
||      A concrete simulation of a multiple queue server.               ||
||      It is concrete in that the state is a single list of queue      ||
||      states, rather than implementing everything in sight as a       ||
||      process communicating along lazy streams.                       ||
||                                                                      ||
||      May 1994                                                        ||
||                                                                      ||
||----------------------------------------------------------------------||

%include "types"
%include "queue"

abstype
  serverState
with
  serverStep     :: serverState -> ( serverState , [outmess] )
  shortestQueue  :: serverState -> num
  addToQueue     :: num -> inmess -> serverState -> serverState
  simulationStep :: serverState -> inmess -> (serverState , [outmess])
  serverStart    :: serverState
  serverSize     :: serverState -> num

||----------------------------------------------------------------------||
||	The server state.						||
||----------------------------------------------------------------------||

serverState == [queueState]

||----------------------------------------------------------------------||
||      Process a server.                                               ||
||      Process each queue separately, and accumulate output messages.  ||
||----------------------------------------------------------------------||

serverStep [] = ( [],[] )
serverStep (q:qs) = ( q' : qs' , mess ++ messes )
                    where
                    ( q' , mess ) = queueStep q
                    ( qs' , messes ) = serverStep qs

||----------------------------------------------------------------------||
||      Add the message im to the queue at index n in serverState st.   ||
||----------------------------------------------------------------------||

addToQueue n im st
        = take n st ++ [newQueueState] ++ drop (n+1) st
          where
          newQueueState = addMessage im (st!n)

||----------------------------------------------------------------------||
||      Add an new object to be processed to the shortest queue, as     ||
||      determined by the shortestQueue function. Adding to the queue   ||
||      queue itself is done by the addToQueue function.                ||
||                                                                      ||
||      NOTE: this only allows a single object to be added to all       ||
||      the queues at each instant. This is OK as only one object       ||
||      arrives each instant.                                           ||
||----------------------------------------------------------------------||

addNewObject :: inmess -> serverState -> serverState

addNewObject No servSt = servSt

addNewObject (Yes arr wait) servSt
        = addToQueue (shortestQueue servSt) (Yes arr wait) servSt

||----------------------------------------------------------------------||
||      The index of the shortest queue -- chooses the highest in a     ||
||      tie.                                                            ||
||----------------------------------------------------------------------||


shortestQueue [q] = 0
shortestQueue (q:qs) 
  = short+1   , if queueLength (qs!short) <= queueLength q
  = 0         , otherwise
    where
    short = shortestQueue qs

||----------------------------------------------------------------------||
||      Process by one unit, then add new object, if any; "compose"     ||
||      serverStep and addNewObject, in other words.                    ||
||----------------------------------------------------------------------||

simulationStep servSt im 
        = ( addNewObject im servSt1 , outmess )
          where
          ( servSt1 , outmess ) = serverStep servSt

||----------------------------------------------------------------------||
||      Start state of server.                                          ||
||----------------------------------------------------------------------||

numServers = 4

serverStart = rep numServers queueStart 

||----------------------------------------------------------------------||
||	Server size							||
||----------------------------------------------------------------------||

serverSize = (#)
