||----------------------------------------------------------------------||
||                                                                      ||
||      types.m                                                         ||
||                                                                      ||
||      Types used in simulations.                                      ||
||                                                                      ||
||      August 1994                                                     ||
||                                                                      ||
||----------------------------------------------------------------------||

||----------------------------------------------------------------------||
||      Four synonyms for numbers, used to make type declarations       ||
||      more readable.                                                  ||
||----------------------------------------------------------------------||

arrival == num
service == num
time    == num
wait    == num

||----------------------------------------------------------------------||
||      Objects arrive at most one per instant. The object is therefore ||
||      identified by its arrival time. An object brings with it its    ||
||      service time -- a positive integer.                             ||
||      These events are coded as objects of type inmess.               ||
||----------------------------------------------------------------------||

inmess ::= No | Yes arrival service

||----------------------------------------------------------------------||
||      A message is generated by the completion of service for a       ||
||      particular object.                                              ||
||      Information is provided about the arrival, waiting and service  ||
||      times.                                                          ||
||----------------------------------------------------------------------||

outmess ::= None | Discharge arrival wait service

||----------------------------------------------------------------------||
||      The state of a queue is described by a list of inmessages,      ||
||      together with a time (service) devoted to the first element in  ||
||      the queue, and the time.                                        ||
||----------------------------------------------------------------------||

||	queueState == (time,service,[inmess])

||----------------------------------------------------------------------||
||      The state of a server (list of queues) is a list of queueStates.||
||----------------------------------------------------------------------||

||	serverState == [queueState]

